VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Œ()
   Caption         =   "GT DeviceMonitor"
   ClientHeight    =   4815
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   6255
   Icon            =   "GTDevmonSample.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   321
   ScaleMode       =   3  '߸
   ScaleWidth      =   417
   StartUpPosition =   3  'Windows ̊l
   Begin VB.CommandButton Command1 
      Caption         =   "&Close"
      Height          =   375
      Left            =   1440
      TabIndex        =   9
      ToolTipText     =   "Close the dialog"
      Top             =   4080
      Width           =   1575
   End
   Begin VB.CommandButton Command2 
      Caption         =   "&Start monitor"
      Height          =   375
      Left            =   3240
      TabIndex        =   10
      ToolTipText     =   "Start/Stop the device monitor"
      Top             =   4080
      Width           =   1575
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   5640
      Top             =   4080
   End
   Begin VB.Frame Frame1 
      Caption         =   "GD Device"
      Height          =   1215
      Left            =   240
      TabIndex        =   11
      Top             =   1440
      Width           =   5775
      Begin VB.TextBox Text2 
         Alignment       =   1  'E
         Height          =   375
         Index           =   0
         Left            =   3360
         TabIndex        =   4
         Text            =   "0"
         ToolTipText     =   "The value to be written into GD device"
         Top             =   240
         Width           =   1095
      End
      Begin VB.CommandButton Command4 
         Caption         =   "Write"
         Height          =   375
         Index           =   0
         Left            =   4560
         TabIndex        =   5
         ToolTipText     =   "Write the value into GD device"
         Top             =   240
         Width           =   1095
      End
      Begin VB.TextBox Text1 
         Alignment       =   1  'E
         Height          =   375
         Index           =   1
         Left            =   1080
         MaxLength       =   5
         TabIndex        =   3
         Text            =   "0"
         Top             =   240
         Width           =   855
      End
      Begin VB.VScrollBar VScroll1 
         Height          =   375
         Index           =   1
         Left            =   1920
         Max             =   -32767
         Min             =   32767
         TabIndex        =   13
         TabStop         =   0   'False
         Top             =   240
         Width           =   255
      End
      Begin VB.Label Label2 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         Height          =   375
         Left            =   3360
         TabIndex        =   12
         Top             =   720
         Width           =   1095
      End
      Begin VB.Label Label7 
         Caption         =   "DeviceNo.:"
         Height          =   255
         Left            =   120
         TabIndex        =   14
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label8 
         Caption         =   "Write Value:"
         Height          =   255
         Left            =   2280
         TabIndex        =   18
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label9 
         Caption         =   "Read Value:"
         Height          =   255
         Left            =   2280
         TabIndex        =   19
         Top             =   840
         Width           =   975
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "GB Device"
      Height          =   1215
      Left            =   240
      TabIndex        =   15
      Top             =   120
      Width           =   5775
      Begin VB.CommandButton Command3 
         Caption         =   "OFF"
         Height          =   375
         Index           =   1
         Left            =   4560
         TabIndex        =   2
         ToolTipText     =   "Turn GB device OFF"
         Top             =   240
         Width           =   1095
      End
      Begin VB.CommandButton Command3 
         Caption         =   "ON"
         Height          =   375
         Index           =   0
         Left            =   3360
         TabIndex        =   1
         ToolTipText     =   "Turn GB device ON"
         Top             =   240
         Width           =   1095
      End
      Begin VB.TextBox Text1 
         Alignment       =   1  'E
         Height          =   375
         Index           =   0
         Left            =   1080
         MaxLength       =   5
         TabIndex        =   0
         Text            =   "0"
         Top             =   240
         Width           =   855
      End
      Begin VB.VScrollBar VScroll1 
         Height          =   375
         Index           =   0
         Left            =   1920
         Max             =   -32767
         Min             =   32767
         TabIndex        =   16
         TabStop         =   0   'False
         Top             =   240
         Width           =   255
      End
      Begin VB.Label Label1 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         Height          =   375
         Left            =   3360
         TabIndex        =   26
         Top             =   720
         Width           =   1095
      End
      Begin VB.Label Label4 
         Caption         =   "DeviceNo.:"
         Height          =   255
         Left            =   120
         TabIndex        =   17
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label5 
         Caption         =   "Write Value:"
         Height          =   255
         Left            =   2280
         TabIndex        =   24
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label6 
         Caption         =   "Read Value:"
         Height          =   255
         Left            =   2280
         TabIndex        =   25
         Top             =   840
         Width           =   975
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "GS Device"
      Height          =   1215
      Left            =   240
      TabIndex        =   20
      Top             =   2760
      Width           =   5775
      Begin VB.TextBox Text1 
         Alignment       =   1  'E
         Height          =   375
         Index           =   2
         Left            =   1080
         MaxLength       =   5
         TabIndex        =   6
         Text            =   "0"
         Top             =   240
         Width           =   855
      End
      Begin VB.TextBox Text2 
         Alignment       =   1  'E
         Height          =   375
         Index           =   1
         Left            =   3360
         TabIndex        =   7
         Text            =   "0"
         ToolTipText     =   "The value to be written into GS device"
         Top             =   240
         Width           =   1095
      End
      Begin VB.CommandButton Command4 
         Caption         =   "Write"
         Height          =   375
         Index           =   1
         Left            =   4560
         TabIndex        =   8
         ToolTipText     =   "Write the value into GS device"
         Top             =   240
         Width           =   1095
      End
      Begin VB.VScrollBar VScroll1 
         Height          =   375
         Index           =   2
         Left            =   1920
         Max             =   -32767
         Min             =   32767
         TabIndex        =   22
         TabStop         =   0   'False
         Top             =   240
         Width           =   255
      End
      Begin VB.Label Label3 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         Height          =   375
         Left            =   3360
         TabIndex        =   23
         Top             =   720
         Width           =   1095
      End
      Begin VB.Label Label10 
         Caption         =   "DeviceNo.:"
         Height          =   255
         Left            =   120
         TabIndex        =   21
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label11 
         Caption         =   "Write Value:"
         Height          =   255
         Left            =   2280
         TabIndex        =   27
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label12 
         Caption         =   "Read Value:"
         Height          =   255
         Left            =   2280
         TabIndex        =   28
         Top             =   840
         Width           =   975
      End
   End
   Begin VB.Label Label13 
      Alignment       =   2  '
      BorderStyle     =   1  '
      Caption         =   "GT SoftGOT2000"
      Height          =   255
      Left            =   0
      TabIndex        =   29
      Top             =   4560
      Width           =   1575
   End
   Begin VB.Label Label14 
      BorderStyle     =   1  '
      Height          =   255
      Left            =   1560
      TabIndex        =   30
      Top             =   4560
      Width           =   4335
   End
   Begin VB.Label Label15 
      Alignment       =   2  '
      BorderStyle     =   1  '
      Height          =   255
      Left            =   5880
      TabIndex        =   31
      Top             =   4560
      Width           =   375
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'GDevlib_GT27 Declaration
Private Declare Function GDev_Read Lib "GDevlib_GT27.dll" (ByVal ulMapPointer As Long, ByVal sDevNameID As Integer, ByVal lDevNum As Long, ByRef lpsDataTable As Integer, ByVal lDataSize As Long) As Long
Private Declare Function GDev_Write Lib "GDevlib_GT27.dll" (ByVal ulMapPointer As Long, ByVal sDeviceNameID As Integer, ByVal lDevNum As Long, ByRef lpsDataTable As Integer, ByVal lDataSize As Long) As Long
Private Declare Function GDev_OpenMapping Lib "GDevlib_GT27.dll" (ByRef lphMapFile As Long, ByVal sGotNo As Integer) As Long
Private Declare Sub GDev_CloseUnMapping Lib "GDevlib_GT27.dll" (ByVal hMapFile As Long, ByVal lMapPointer As Long)

Private Const GDEV_GB_ID = 0
Private Const GDEV_GD_ID = 1
Private Const GDEV_GS_ID = 2

Private Const GDEV_OK = 0
Private Const GDEV_ERR_DEV_NAME_ID = -1
Private Const GDEV_ERR_DEV_NUM_MIN = -2
Private Const GDEV_ERR_DEV_NUM_MAX = -3
Private Const GDEV_ERR_MAP_POINTER = -9

'Form1 Declaration
Private Const SWNO_SOFTGOT = 1
Private Const GBGD_NUM_MAX = 65535
Private Const GS_NUM_MAX = 2047
Private Const INT_VALUE_MAX = 32767
Private Const INT_VALUE_MIN = -32768
Private Const FORCED = 1

Dim lMapFile As Long
Dim lMapPointer As Long
Dim lMaskTable(15) As Long

Private Sub Form_Load()

    Dim iLoop As Integer

    lMaskTable(0) = &H1
    For iLoop = 0 To 14
        lMaskTable(iLoop + 1) = lMaskTable(iLoop) * &H2
    Next

End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)

    Dim bRet As Boolean

    If UnloadMode = 0 Then
        bRet = Termination
        If bRet = False Then
            Cancel = True
        End If
    End If

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// Dialog Close.

Private Sub Command1_Click()

    Dim bRet As Boolean

    bRet = Termination
    If bRet = False Then
        Exit Sub
    End If

    End

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// Monior Start.

Private Sub Command2_Click()

    Dim bRet As Boolean

    If Command2.Caption = "&Start monitor" Then
        If MsgBox("The monitor is about to be started." & vbLf & "Is it OK?", vbOKCancel + vbExclamation) = 1 Then
            lMapPointer = GDev_OpenMapping(lMapFile, SWNO_SOFTGOT)

            If lMapPointer = 0 Then
                Call MsgBox("GT SoftGOT2000 has not been started." & vbLf & "(Cannot access the internal device)", vbOKOnly + vbCritical)
                Exit Sub
            End If

            Label15.Caption = "*"
            Command2.Caption = "&Stop monitor"

            Timer1.Enabled = True
        End If

    Else
        bRet = Termination
    End If

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// GB Device Write. (ON:Index = 0, OFF:Index = 1)

Private Sub Command3_Click(Index As Integer)

    Dim iDataTable(255) As Integer
    Dim lRet As Long
    Dim NotMaskValue As Integer
    Dim iValue As Integer
    Dim lDevNo As Long
    Dim lInputDevNo As Long

    lDevNo = 0
    lInputDevNo = 0

    If lMapPointer = 0 Then
        Call MsgBox("The monitor is out of operation." & vbLf & "(Start the monitor)", vbOKOnly + vbExclamation)
        Exit Sub
    End If

    If IsNumeric(Text1(0).Text) = True Then
        lInputDevNo = Int(Text1(0).Text)
        If lInputDevNo < 0 Then
            lInputDevNo = 0
        ElseIf lInputDevNo > GBGD_NUM_MAX Then
            lInputDevNo = GBGD_NUM_MAX
        End If
        
        lDevNo = Fix(lInputDevNo / 16) * 16
    
    End If
        
    lRet = GDev_Read(lMapPointer, 0, lDevNo, iDataTable(0), 1)
        
    Select Case lRet
        Case GDEV_OK
            If Index = 0 Then
                iDataTable(0) = iDataTable(0) Or CInt("&H" & Hex(lMaskTable(lInputDevNo Mod 16)))
            Else
                iNotMaskValue = Not CInt("&H" & Hex(lMaskTable(lInputDevNo Mod 16)))
                iDataTable(0) = iDataTable(0) And iNotMaskValue
            End If
            
            lRet = GDev_Write(lMapPointer, 0, lDevNo, iDataTable(0), 1)
                    
            Select Case lRet
                Case GDEV_OK
                Case GDEV_ERR_DEV_NAME_ID
                Case GDEV_ERR_DEV_NUM_MIN
                Case GDEV_ERR_DEV_NUM_MAX
                Case GDEV_ERR_MAP_POINTER
                Case Else
            End Select

        Case GDEV_ERR_DEV_NAME_ID
        Case GDEV_ERR_DEV_NUM_MIN
        Case GDEV_ERR_DEV_NUM_MAX
        Case GDEV_ERR_MAP_POINTER
        Case Else
    End Select

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// GD/GS Device Write. (GD:Index = 0, GS:Index = 1)

Private Sub Command4_Click(Index As Integer)

    Dim iDataTable(255) As Integer
    Dim lRet As Long
    Dim lDevNo As Long

    iDataTable(0) = 0
    lDevNo = 0

    If lMapPointer = 0 Then
        Call MsgBox("The monitor is out of operation." & vbLf & "(Start the monitor)", vbOKOnly + vbExclamation)
        Exit Sub
    End If

    If IsNumeric(Text1(Index + 1).Text) = True Then
        Select Case Index
            Case 0
                If Int(Text1(Index + 1).Text) >= 0 Then
                    lDevNo = Int(Text1(Index + 1).Text)
                End If
            Case 1
                If Int(Text1(Index + 1).Text) >= 0 Then
                    lDevNo = Int(Text1(Index + 1).Text)
                End If
            Case Else
                Exit Sub
        End Select
    End If

    If IsNumeric(Text2(Index).Text) = True Then
        If Int(Text2(Index).Text) >= INT_VALUE_MIN And Int(Text2(Index).Text) <= INT_VALUE_MAX Then
            iDataTable(0) = Text2(Index).Text

            lRet = GDev_Write(lMapPointer, (Index + 1), lDevNo, iDataTable(0), 1)
            Select Case lRet
                Case GDEV_OK
                Case GDEV_ERR_DEV_NAME_ID
                Case GDEV_ERR_DEV_NUM_MIN
                Case GDEV_ERR_DEV_NUM_MAX
                Case GDEV_ERR_MAP_POINTER
                Case Else
            End Select

        Else
            Call MsgBox("Please enter an integer between -32768 and 32767.", vbOKOnly + vbExclamation)
        End If

    Else
        Call MsgBox("Please enter an integer between -32768 and 32767.", vbOKOnly + vbExclamation)
    End If

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// TextBox1 Input check.

Private Sub Text1_KeyPress(Index As Integer, KeyAscii As Integer)

    If KeyAscii >= 32 And KeyAscii < 48 Or KeyAscii > 57 Then
        KeyAscii = 0
    End If

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// TextBox1 Device range check.

Private Sub Text1_LostFocus(Index As Integer)

    If Text1(Index).Text = "" Then
        Text1(Index).Text = 0
    End If

    If IsNumeric(Text1(Index).Text) = True Then
        If Text1(Index).Text < 0 Then
            Call MsgBox("It is out of the device-specified range." & vbLf & "Specify the value within the range.", vbOKOnly + vbExclamation)
            Text1(Index).Text = 0
        ElseIf Index = GDEV_GS_ID Then
            If Text1(Index).Text > GS_NUM_MAX Then
                Call MsgBox("It is out of the device-specified range." & vbLf & "Specify the value within the range.", vbOKOnly + vbExclamation)
                Text1(Index).Text = GS_NUM_MAX
            End If
        ElseIf Text1(Index).Text > GBGD_NUM_MAX Then
            Call MsgBox("It is out of the device-specified range." & vbLf & "Specify the value within the range.", vbOKOnly + vbExclamation)
            Text1(Index).Text = GBGD_NUM_MAX
        End If
    End If

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// TextBox2 Input check.

Private Sub Text2_KeyPress(Index As Integer, KeyAscii As Integer)

    If KeyAscii >= 32 And KeyAscii < 48 Or KeyAscii > 57 Then
        If KeyAscii <> 45 Then
            KeyAscii = 0
        End If
    End If

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// ScrollBar.

Private Sub VScroll1_Change(Index As Integer)

    Dim iTextIndex As Integer

    Text1(Index).SetFocus

    If IsNumeric(Text1(Index).Text) <> True Then
        Text1(Index).Text = 0
    End If

    If VScroll1(Index).Value > 0 Then
        If Text1(Index).Text < 0 Then
            Text1(Index).Text = 1
        Else
            Select Case Index
                Case GDEV_GS_ID
                    If Text1(Index).Text >= GS_NUM_MAX Then
                        Text1(Index).Text = GS_NUM_MAX
                    Else
                        Text1(Index).Text = Text1(Index).Text + 1
                    End If
                Case Else
                    If Text1(Index).Text >= GBGD_NUM_MAX Then
                        Text1(Index).Text = GBGD_NUM_MAX
                    Else
                        Text1(Index).Text = Text1(Index).Text + 1
                    End If
            End Select
        End If

    ElseIf VScroll1(Index).Value < 0 Then
        If Text1(Index).Text <= 0 Then
            Text1(Index).Text = 0
        Else
            Select Case Index
                Case GDEV_GS_ID
                    If Text1(Index).Text > GS_NUM_MAX Then
                        Text1(Index).Text = GS_NUM_MAX - 1
                    Else
                        Text1(Index).Text = Text1(Index).Text - 1
                    End If
                Case Else
                    If Text1(Index).Text > GBGD_NUM_MAX Then
                        Text1(Index).Text = GBGD_NUM_MAX - 1
                    Else
                        Text1(Index).Text = Text1(Index).Text - 1
                    End If
            End Select
        End If

    End If

    VScroll1(Index).Value = 0

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// Monitor routine.

Private Sub Timer1_Timer()

    Dim lRet As Long
    Dim iDataTable(255) As Integer
    Dim stOutputText As String
    Dim lDevNo As Long
    Dim lInputDevNo As Long

    lDevNo = 0
    lInputDevNo = 0

    '// Device error check.
    If lMapPointer = 0 Then
        Timer1.Enabled = False
        Call MsgBox("Cannot refer to the internal device." & vbLf & "The monitor is about to be terminated.", vbOKOnly + vbCritical)
        End
    End If

    '// GB Device Access.
    If IsNumeric(Text1(0).Text) = True Then
        lInputDevNo = Int(Text1(0).Text)
        If lInputDevNo < 0 Then
            lInputDevNo = 0
        ElseIf lInputDevNo > GBGD_NUM_MAX Then
            lInputDevNo = GBGD_NUM_MAX
        End If
        
        lDevNo = Fix(lInputDevNo / 16) * 16
    
    End If

    lRet = GDev_Read(lMapPointer, GDEV_GB_ID, lDevNo, iDataTable(0), 1)

    Select Case lRet
        Case GDEV_OK
            If (iDataTable(0) And lMaskTable(lInputDevNo Mod 16)) <> 0 Then
                Label1.Caption = 1
            Else
                Label1.Caption = 0
            End If

        Case GDEV_ERR_DEV_NAME_ID
        Case GDEV_ERR_DEV_NUM_MIN
        Case GDEV_ERR_DEV_NUM_MAX
        Case GDEV_ERR_MAP_POINTER
        Case Else
    End Select

    '// GD Device Access.
    If IsNumeric(Text1(1).Text) = True Then
        If Text1(1).Text >= 0 And Text1(1).Text <= GBGD_NUM_MAX Then
            lRet = GDev_Read(lMapPointer, GDEV_GD_ID, Int(Text1(1).Text), iDataTable(0), 1)
        ElseIf Text1(1).Text < 0 Then
            lRet = GDev_Read(lMapPointer, GDEV_GD_ID, 0, iDataTable(0), 1)
        Else
            lRet = GDev_Read(lMapPointer, GDEV_GD_ID, GBGD_NUM_MAX, iDataTable(0), 1)
        End If
    Else
        lRet = GDev_Read(lMapPointer, GDEV_GD_ID, 0, iDataTable(0), 1)
    End If

    Select Case lRet
        Case GDEV_OK
            Label2.Caption = iDataTable(0)

        Case GDEV_ERR_DEV_NAME_ID
        Case GDEV_ERR_DEV_NUM_MIN
        Case GDEV_ERR_DEV_NUM_MAX
        Case GDEV_ERR_MAP_POINTER
        Case Else
    End Select

    '// GS Device Access.
    If IsNumeric(Text1(2).Text) = True Then
        If Text1(2).Text >= 0 And Text1(2).Text <= GS_NUM_MAX Then
            lRet = GDev_Read(lMapPointer, GDEV_GS_ID, Int(Text1(2).Text), iDataTable(0), 1)
        ElseIf Text1(2).Text < 0 Then
            lRet = GDev_Read(lMapPointer, GDEV_GS_ID, 0, iDataTable(0), 1)
        Else
            lRet = GDev_Read(lMapPointer, GDEV_GS_ID, GS_NUM_MAX, iDataTable(0), 1)
        End If
    Else
        lRet = GDev_Read(lMapPointer, GDEV_GS_ID, 0, iDataTable(0), 1)
    End If

    Select Case lRet
        Case GDEV_OK
            Label3.Caption = iDataTable(0)

        Case GDEV_ERR_DEV_NAME_ID
        Case GDEV_ERR_DEV_NUM_MIN
        Case GDEV_ERR_DEV_NUM_MAX
        Case GDEV_ERR_MAP_POINTER
        Case Else
    End Select

End Sub

'/////////////////////////////////////////////////////////////////////////////
'// Monitor termination

Private Function Termination() As Boolean

    Dim bRet As Boolean

    bRet = True

    If lMapFile <> 0 And lMapPointer <> 0 Then
        If MsgBox("The monitor is about to be discontinued." & vbLf & "Is it OK to proceed?", vbOKCancel + vbExclamation) = 1 Then
            Timer1.Enabled = False
            Call GDev_CloseUnMapping(lMapFile, lMapPointer)

            Label15.Caption = ""
            lMapFile = 0
            lMapPointer = 0
            Command2.Caption = "&Start monitor"
        Else
            bRet = False
        End If
    End If

    Termination = bRet

End Function

